//
//  MCReportImage.h
//  Composer
//
//  Created by Alykhan Jetha on 04/06/2005.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import "MCReportElement.h"



@interface MCReportImage : MCReportElement {
	int typeCode;
	NSString *imageSourceKey;
	NSString *imageSourceKeyBundleIdentifier;
	NSString *cacheKey;
	NSImageCell *imageCell;
	NSMutableArray *compareRules;
	NSString *defaultImageName;
	NSString *defaultImageNameBundleIdentifier;
	NSImage *image;
	NSImage *imageCopyForLayout;
	NSImage *imageCopyForCanvas;
	NSImageScaling imageScaling;
	NSImageAlignment imageAlignment;
}

- (NSImageCell *)imageCell;
- (void)setImageCell:(NSImageCell *)anImageCell;

- (NSImage *)image;
- (void)setImage:(NSImage *)anImage;
- (void)setImageManually:(NSImage *)anImage;

// creates a copy of the image if one does not already exist
- (NSImage *)getImageCopyForLayout;
- (NSImage *)imageCopyForLayout;
- (void)setImageCopyForLayout:(NSImage *)anImageCopyForLayout;

// creates a copy of the image if one does not already exist
- (NSImage *)getImageCopyForCanvas;
- (NSImage *)imageCopyForCanvas;
- (void)setImageCopyForCanvas:(NSImage *)anImageCopyForCanvas;

- (NSString *)defaultImageName;
- (void)setDefaultImageName:(NSString *)aDefaultImageName;

- (NSString *)defaultImageNameBundleIdentifier;
- (void)setDefaultImageNameBundleIdentifier:(NSString *)aDefaultImageNameBundleIdentifier;

- (int)typeCode;
- (void)setTypeCode:(int)aTypeCode;

// returns NSString, NSNumber, NSData, NSImage depending on typeCode
- (NSArray *)acceptableSourceKeyKinds;

- (BOOL)userCanEditImageSourceKey;
- (NSString *)imageSourceKey;
- (void)setImageSourceKey:(NSString *)anImageSourceKey;
- (id)getSourceKeyValue;
- (BOOL)setupForImageAtAbsolutePath:(NSString *)aPath;

- (NSMutableArray *)compareRules;
- (void)setCompareRules:(NSMutableArray *)aCompareRules;

- (NSString *)imageSourceKeyBundleIdentifier;
- (void)setImageSourceKeyBundleIdentifier:(NSString *)anImageSourceKeyBundleIdentifier;



- (BOOL)needsImageSourceKey;

- (void)loadImageFromCache;
- (void)cacheStaticImageIfNeeded;


- (NSImageAlignment)imageAlignment;
- (void)setImageAlignment:(NSImageAlignment)alignment;

- (NSImageFrameStyle)imageFrameStyle;
- (void)setImageFrameStyle:(NSImageFrameStyle)frameStyle;

- (NSImageScaling)imageScaling;
- (void)setImageScaling:(NSImageScaling)scaling;



@end

@interface NSView (MCReportImageAddition)

- (void)propagateLoadImageFromCache;
- (void)propagateCacheStaticImage;

@end
